/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.client.commands;

import com.dodgeman.shw.client.commands.CommandLineFormatter;
import com.dodgeman.shw.saveddata.SetHomeAndWaypointsSavedData;
import com.dodgeman.shw.saveddata.SetHomeWaypointsSavedDataFactory;
import com.dodgeman.shw.saveddata.mappers.PositionMapper;
import com.dodgeman.shw.saveddata.models.Home;
import com.dodgeman.shw.saveddata.models.PlayerHomeAndWaypoints;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class SetHomeCommand {
    public static final String COMMAND_NAME = "sethome";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_NAME).requires(CommandSourceStack::m_230897_)).executes(SetHomeCommand::setHome));
    }

    private static int setHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        SetHomeAndWaypointsSavedData savedData = new SetHomeWaypointsSavedDataFactory().createAndLoad();
        PlayerHomeAndWaypoints playerHomeAndWaypoints = savedData.getPlayerHomeAndWaypoints(player.m_20148_());
        Home currentHome = playerHomeAndWaypoints.getHome();
        Home newHome = new Home(PositionMapper.fromPlayer(player));
        MutableComponent successMessage = null;
        if (newHome.position().isInTheNether() && !playerHomeAndWaypoints.hasAlreadySetHomeInTheNether()) {
            successMessage = Component.m_237110_((String)"shw.commands.sethome.success.the_nether", (Object[])new Object[]{Component.m_237113_((String)"The Nether").m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN);
        }
        if (newHome.position().isInTheEnd() && !playerHomeAndWaypoints.hasAlreadySetHomeInTheEnd()) {
            successMessage = Component.m_237110_((String)"shw.commands.sethome.success.the_end", (Object[])new Object[]{Component.m_237113_((String)"The End").m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN);
        }
        if (currentHome == null) {
            successMessage = Component.m_237110_((String)"shw.commands.sethome.success.first_home", (Object[])new Object[]{CommandLineFormatter.formatCommand("home")}).m_130940_(ChatFormatting.GREEN);
        }
        if (successMessage == null) {
            successMessage = Component.m_237115_((String)"shw.commands.sethome.success.update").m_130940_(ChatFormatting.GREEN);
        }
        playerHomeAndWaypoints.setNewHome(newHome);
        savedData.m_77762_();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)successMessage, false);
        return 1;
    }
}

